
markup.push({

// MARK: app block

ApplicationSourceBlock:
{
	"+": "SourceTemplate",
	geNodeClass: "GEAppWrapperNode",
	geInputRank: 2,	
    h4PresetsId: "ApplicationPresets",
    gxTitle: "Application",
	gxNodeInitialProperties: { targetApplicationPath: "" },	// force recent app to be loaded
    gxLibraryDescription: "Capture audio from any application",
	gxLibraryIcon: "library.app.generic",
	gxDescriptionKeyPath: "node.appDisplayName",
	gxPopoverInfo: "ApplicationPopover",
	gxChildViews:
	[
		// drop view
		{
			nsClass: "GXDropView",
			gxValueKey: "node.droppedApps",
			acceptDroppedApps: true,
			gxFrameRect: "4,4,112,112",
			gxLayerZPosition: 2,
			gxHilitePainter: {
				"+": "DropHilitePainter",
				gxStrokeWidth: 5,
				gxCornerRadius: 14.5,
			},
		},
		// app icon
		{
			nsClass: "GXDrawView",
			gxForePainter: "ImagePainter.trimImage.block.app.select",
			gxValueKey: "node.appIcon",
			gxFrameRect: "20,36,80,48",
		},
		// app name
		{
			"+": "LabelView.centery.lineSquash1.foreColorTheme1.size105.wrap.useMarkup",
			gxValueKey: "node.appTitleMarkup",
			gxFrameRect: "11,84,98,28",
			axIsIgnored: true	// avoid VO reading title twice (blockDescription covers it)
		},
//		// badge
//		{
//			nsClass: "GXDrawView",
//			gxForePainter: "ImagePainter.colorThemeLive1.block.app.selectbadge",
//			gxShowOnKey: "node.hasNoTarget",
//            gxFrameRect: "20,35,80,42"
//		},
	]
},

// MARK: app popover

ApplicationPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Application Source",
	gxLayout: [
		"H:|-12-[self(410)]-12-|",	// popover width
		"V:|-12-[self]-12-|",
		"V:|-41-[group]-6-[presetsGroup]"
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup("stripMarkup"),
		group:
		{
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",

				"H:|-13-[appPopup]-12-|",
				"H:|-13-[dropView]-12-|",

				"V:|-10-[groupTitle]",
				"V:|-35-[appPopup(42)]-10-[targetEnabled]-5-[targetUrl(26)]-12-[devicesBtn]-0-[devices]-0-[advancedBtn]-0-[advanced]-0-|",
				"V:|-35-[dropView(42)]",

				"H:|-12-[targetEnabled(100)]",
				"H:|-33-[targetUrlLabel]-8-[targetUrl]-12-|&alignBaseline",
			],
			gxChildViews:
			{
				groupTitle: groupTitleView("Source"),
				dropView: {
					nsClass: "GXDropView",
					gxValueKey: "node.droppedApps",
					acceptDroppedApps: true,
					gxLayerZPosition: 2,
					gxHilitePainter: {
						"+": "DropHilitePainter",
						gxCornerRadius: 7,
					},
				},
				appPopup: {
					nsClass: "GEAppPopupView",
					gxValueKey: "node.targetApplication",
					defaultAppIcon: "block.app.generic",
					gxIconPainter: {
						"+": "ImagePainter.trimImage.left",
						gxEdgeInsets: "12, 6, 0, 6",
					},
					gxBackPainter: "ControlBack",
					gxTitlePainter:  {
						"+": "LabelFore.useMarkup.left.size16",
						gxEdgeInsets: "52,0,2,0",
						gxFontColor: "ForeColor1",
						error: {
							gxFontColor: errorColor(99),
							disabled:     { gxFontColor: errorColor(40) }
						},
					},
					gxArrowPainter: "ImagePainter.foreColor1.app.pulldown.arrow",
					axTitle: "Source Application",
					axHelp: "Choose an application source",
				},
				targetEnabled: {
					"+": "CheckboxTemplate",
					gxTitle: "<checkbox/> Open URL",
					gxValueKey: "node.targetURLEnabled",
					gxDisableOnKey: "running"
				},
				targetUrl: {
					"+": "DarkTextField",
					axTitle: "URL",
					gxValueKey: "node.targetURLString",
					gxPlaceholderString: "This URL will be opened when the session starts.",
					gxLineBreakMode: 0,	// word wrap
					gxDisableOnKey: "node.disableTargetURLField",
				},
                targetUrlLabel: labelView("URL:"),
                devicesBtn: {
                    "+": "AdvancedGroupButton",
                    gxTitle: "<disclosure/> Audio Device Selection",
					axFormatter: disclosureAxFormatter("Audio Capture"),
                    gxValueKey: "uiState.devicesExpanded"
                },
				devices: {
					"+": "ExpandingGroupView.noTopStroke",
					gxValueKey: "uiState.devicesExpanded",
					gxCollapsible: true,
                    gxCollapsedSize: 1,
					gxExtraSize: 12,
					axTitle: "Device Selection",
					gxLayout:
					[
						"H:|-0-[self]-0-|",
						"V:|-2-[captureDefault]-4-[captureAll]-4-[captureSelected]-6-[scrollView(106)]-4-[addDeviceBtn]",
						
						//"V:[captureSelected]-10-[textDefault(30)]",
						//"H:|-37-[textDefault]-20-|",
												
						"H:|-0-[scrollView]-0-|",
						"H:|-13-[captureDefault(330)]",
						"H:|-13-[captureAll(330)]",
						"H:|-13-[captureSelected(320)]",
						"H:|-35-[addDeviceBtn(105)]-(>=10)-[deleteDeviceBtn(24)]-14-|&alignBaseline",
						//"H:|-37-[text4]-20-|"
					],
					gxChildViews:
					{
						captureDefault: {
							"+": "CheckboxTemplate",
							gxTitle: "<radioButton/> Capture audio played to the default output device",
							gxValueKey: "node.captureDefaultDevice"
						},
						captureAll: {
							"+": "CheckboxTemplate",
							gxTitle: "<radioButton/> Capture audio played to all output devices",
							gxValueKey: "node.captureAllDevices"
						},
						captureSelected: {
							"+": "CheckboxTemplate",
							gxTitle: "<radioButton/> Capture audio played to the specified devices:",
							gxValueKey: "node.captureSpecificDevices"
						},
//						textDefault: {
//							"+": "DescriptionLabelView",
//							gxDefaultValue: "Capture will be limited to audio the source application is sending to the Mac’s default output device.",
//							gxValueKey: "node.defaultTinyText",
//							gxShowOnKey: "node.captureDefaultDevice",
//						},
						scrollView: {
							nsClass: "GXScrollView",
							gxBackColor: "SidebarBackColor3",
							gxVScrollbar: "ScrollBarView",
							gxScrollbarWidth: 13,
							gxShowOnKey: "node.captureSpecificDevices",
							gxDocumentView:
							{
								nsClass: "GXListView",
								gxViewName: "captureDeviceListView",
								gxListItemView: "CaptureDeviceListItem",
								gxDeleteKey: "node.deleteDeviceBtn",
								axIsIgnored: false,
								axTitle: "Capture devices list",
								//axHelp: "App sources in this list are not included in the captured audio",
								gxValueKey: "node.captureDeviceList.subModels",
								gxCopyValues: true,
								gxItemHeight: 30,
								gxTopHeight: 5,
								gxInterItemHeight: 1,
								gxBottomHeight: 6,
								gxLayout: [ "H:|-0-[self]-0-|" ],
							},
						},
						addDeviceBtn: {
							"+": "PlusButton",
							gxTitle: "<plusButton/> Add Device", // \u2002 is 'en space'
							gxValueKey: "node.addDeviceBtn",
							gxShowOnKey: "node.captureSpecificDevices",
						},
						deleteDeviceBtn: {
							"+": "MinusButton",
							gxTitle: "<minusButton/>",
							axTitle: "Delete device",
							gxValueKey: "node.deleteDeviceBtn",
							gxShowOnKey: "node.captureSpecificDevices",
						},
//						text4: {
//							"+": "DescriptionLabelView",
//							gxValueKey: "node.specificTinyText",
//							gxDefaultValue: "Capture will be limited to audio the source application is sending to the devices specified above.",
//							gxShowOnKey: "node.captureSpecificDevices",
//						},
					}
				},
				advancedBtn:
				{
                    "+": "AdvancedGroupButton.noTopStroke",
                    gxTitle: "<disclosure/> Advanced",
					axFormatter: disclosureAxFormatter("Advanced"),
                    gxValueKey: "uiState.advancedExpanded"
                },
				advanced:
				{
					"+": "ExpandingGroupView.noTopStroke",
					gxValueKey: "uiState.advancedExpanded",
					gxCollapsible: true,
                    gxCollapsedSize: 1,
					gxExtraSize: 12,
					//axTitle: "Advanced Group",
					gxLayout:
					[
						"H:|-0-[self]-0-|",
						"V:|-2-[captureInputs]-4-[text1(56)]-8-[splitChannels]-4-[text2(30)]-8-[continuousFlow]-4-[text3(30)]",
						
						"H:|-12-[captureInputs(150)]",
						"H:|-37-[text1]-20-|",
						"H:|-35-[splitChannels(170)]",
						"H:|-60-[text2]-20-|",
						"H:|-12-[continuousFlow(220)]",
						"H:|-37-[text3]-20-|",
					],
					gxChildViews:
					{
						captureInputs: {
							"+": "CheckboxTemplate",
							gxTitle: "<checkbox/> Include audio input",
							gxValueKey: "node.captureInputs"
						},
						text1: {
							"+": "DescriptionLabelView",
							gxDefaultValue: "In addition to the standard capture of the application's audio output, audio from input devices like microphones will also be included. Use this setting to record both sides of a voice chat (VoIP) conversation."
						},
						splitChannels: {
							"+": "CheckboxTemplate",
							gxTitle: "<checkbox/> Split between channels",
							gxValueKey: "node.splitChannels",
							gxDisableOnKey: "node.disableSplitChannels"
						},
						text2: {
							"+": "DescriptionLabelView",
							gxDefaultValue: "Audio inputs will be placed on the left channel, while the application's audio output will be placed on the right channel."
						},
						continuousFlow: {
							"+": "CheckboxTemplate",
							gxTitle: "<checkbox/> Fill playback gaps with silence",
							gxValueKey: "node.continuousFlow"
						},
						text3: {
							"+": "DescriptionLabelView",
							gxDefaultValue: "If no audio is being played by the source application, silence will be generated and added."
						},
					},
				},
			}
		}
	}
},



// MARK: - capture device model

CaptureDeviceModel:
{
	nsClass: "AH4CaptureDevice",
},

// MARK: - capture device item view

CaptureDeviceListItem:
{
	nsClass: "GXListItemView",
	gxSelectable: 2,  // multiselect
	gxBackPainter: {
		"+": "ListItemBack",
		gxCornerRadius: 10,
		gxEdgeInsets: "22, 0, 0, 0",
		gxFillColor: "",  // skip fill until selected
	},
	gxLateLayout:
	[
		"V:|-(-999)-[self(30)]",		// vertical position set by parent

		"H:|-0-[self]",
		"H:|-38-[device(218)]-6-[leftLabel]-3-[leftChannel(42)]-6-[rightLabel]-3-[rightChannel(42)]-14-|&alignBaseline",

		"V:|-3-[device]",
	],
	gxChildViews:
	{
		device: {
			"+": "PopupMenuView.useMarkup.listBack",
			gxValueKey: "deviceValue",
			gxMenuItemsKeyPath: "deviceMenuItems",
			gxDisplayValueKey: "deviceDisplayValue",
			gxHideOnNilValue: false,
		},
		leftChannel: {
			"+": "PopupMenuView.useMarkup.centerx.listBack.tightTitle",
			gxValueKey: "leftChannel",
			gxMenuItemsKeyPath: "channelMenuItems",
			gxDisplayValueKey: "leftChannelDisplayValue",
			axTitle: "Left Channel",
		},
		leftLabel: labelView("L:"),
		rightChannel: {
			"+": "PopupMenuView.useMarkup.centerx.listBack.tightTitle",
			gxValueKey: "rightChannel",
			gxMenuItemsKeyPath: "channelMenuItems",
			gxDisplayValueKey: "rightChannelDisplayValue",
			axTitle: "Right Channel",
		},
		rightLabel: labelView("R:"),
	},
},



})
